# Quantitative evidence synthesis: a practical guide on meta-analysis, meta-regression, and publication bias tests for environmental sciences

Shinichi Nakagawa $1 , 2 ^ { * } \oplus _ { \prime }$ Yefeng Yang $1 ^ { * } \oplus ,$ Erin L. Macartney1 , Rebecca Spake3 and Malgorzata Lagisz1

# Abstract

Meta-analysis is a quantitative way of synthesizing results from multiple studies to obtain reliable evidence of an intervention or phenomenon. Indeed, an increasing number of meta-analyses are conducted in environmental sciences, and resulting meta-analytic evidence is often used in environmental policies and decision-making. We conducted a survey of recent meta-analyses in environmental sciences and found poor standards of current meta-analytic practice and reporting. For example, only $\sim 4 0 \%$ of the 73 reviewed meta-analyses reported heterogeneity (variation among efect sizes beyond sampling error), and publication bias was assessed in fewer than half. Furthermore, although almost all the meta-analyses had multiple efect sizes originating from the same studies, non-independence among efect sizes was considered in only half of the meta-analyses. To improve the implementation of meta-analysis in environmental sciences, we here outline practical guidance for conducting a meta-analysis in environmental sciences. We describe the key concepts of efect size and meta-analysis and detail procedures for ftting multilevel metaanalysis and meta-regression models and performing associated publication bias tests. We demonstrate a clear need for environmental scientists to embrace multilevel meta-analytic models, which explicitly model dependence among efect sizes, rather than the commonly used random-efects models. Further, we discuss how reporting and visual presentations of meta-analytic results can be much improved by following reporting guidelines such as PRISMAEcoEvo (Preferred Reporting Items for Systematic Reviews and Meta-Analyses for Ecology and Evolutionary Biology). This paper, along with the accompanying online tutorial, serves as a practical guide on conducting a complete set of meta-analytic procedures (i.e., meta-analysis, heterogeneity quantifcation, meta-regression, publication bias tests and sensitivity analysis) and also as a gateway to more advanced, yet appropriate, methods.

Keywords Hierarchical models, Robust variance estimation, Spatial dependency, Variance–covariance matrix, Metaanalysis of variance, Missing data, Network meta-analysis, Multivariate meta-analysis

# Background

Evidence synthesis is an essential part of science. Te method of systematic review provides the most trusted and unbiased way to achieve the synthesis of evidence [1–3]. Systematic reviews often include a quantitative summary of studies on the topic of interest, referred to as a meta-analysis (for discussion on the defnitions of ‘meta-analysis’, see [4]). Te term meta-analysis can also mean a set of statistical techniques for quantitative data synthesis. Te methodologies of the meta-analysis were initially developed and applied in medical and social sciences. However, meta-analytic methods are now used in many other felds, including environmental sciences [5–7]. In environmental sciences, the outcomes of metaanalyses (within systematic reviews) have been used to inform environmental and related policies (see [8]). Terefore, the reliability of meta-analytic results in environmental sciences is important beyond mere academic interests; indeed, incorrect results could lead to inefective or sometimes harmful environmental policies [8].

As in medical and social sciences, environmental scientists frequently use traditional meta-analytic models, namely fxed-efect and random-efects models [9, 10]. However, we contend that such models in their original formulation are no longer useful and are often incorrectly used, leading to unreliable estimates and errors. Tis is mainly because the traditional models assume independence among efect sizes, but almost all primary research papers include more than one efect size, and this nonindependence is often not considered (e.g., [11–13]). Furthermore, previous reviews of published meta-analyses in environmental sciences (hereafter, ‘environmental metaanalyses’) have demonstrated that less than half report or investigate heterogeneity (inconsistency) among efect sizes [14–16]. Many environmental meta-analyses also do not present any sensitivity analysis, for example, for publication bias (i.e., statistically signifcant efects being more likely to be published, making collated data unreliable; [17, 18]). Tese issues might have arisen for several reasons, for example, because of no clear conduct guideline for the statistical part of meta-analyses in environmental sciences and rapid developments in meta-analytic methods. Taken together, the feld urgently requires a practical guide to implement correct meta-analyses and associated procedures (e.g., heterogeneity analysis, metaregression, and publication bias tests; cf. [19]).

To assist environmental scientists in conducting metaanalyses, the aims of this paper are fve-fold. First, we provide an overview of the processes involved in a metaanalysis while introducing some key concepts. Second, after introducing the main types of efect size measures, we mathematically describe the two commonly used traditional meta-analytic models, demonstrate their utility, and introduce a practical, multilevel meta-analytic model for environmental sciences that appropriately handles non-independence among efect sizes. Tird, we show how to quantify heterogeneity (i.e., consistencies among efect sizes and/or studies) using this model, and then explain such heterogeneity using meta-regression. Fourth, we show how to test for publication bias in a meta-analysis and describe other common types of sensitivity analysis. Fifth, we cover other technical issues relevant to environmental sciences (e.g., scale and phylogenetic dependence) as well as some advanced meta-analytic techniques. In addition, these fve aims (sections) are interspersed with two more sections, named ‘Notes’ on: (1) visualisation and interpretation; and (2) reporting and archiving. Some of these sections are accompanied by results from a survey of 73 environmental meta-analyses published between 2019 and 2021; survey results depict current practices and highlight associated problems (for the method of the survey, see Additional fle 1). Importantly, we provide easy-to-follow implementations of much of what is described below, using the $R$ package, metafor [20] and other $R$ packages at the webpage (https://itchyshin.github.io/Meta-analysis_tutorial/), which also connects the reader to the wealth of online information on meta-analysis (note that we also provide this tutorial as Additional fle 2; see also [21]).

# Overview with key concepts

Statistically speaking, we have three general objectives when conducting a meta-analysis [12]: (1) estimating an overall mean, (2) quantifying consistency (heterogeneity) between studies, and (3) explaining the heterogeneity (see Table  1 for the defnitions of the terms in italic). A notable feature of a meta-analysis is that an overall mean is estimated by taking the sampling variance of each efect size into account: a study (efect size) with a low sampling variance (usually based on a larger sample size) is assigned more weight in estimating an overall mean than one with a high sampling variance (usually based on a smaller sample size). However, an overall mean estimate itself is often not informative because one can get the same overall mean estimates in diferent ways. For example, we may get an overall estimate of zero if all studies have zero efects with no heterogeneity. In contrast, we might also obtain a zero mean across studies that have highly variable efects (e.g., ranging from strongly positive to strongly negative), signifying high heterogeneity. Terefore, quantifying indicators of heterogeneity is an essential part of a meta-analysis, necessary for interpreting the overall mean appropriately. Once we observe nonzero heterogeneity among efect sizes, then, our job is to explain this variation by running meta-regression models, and, at the same time, quantify how much variation is accounted for (often quantifed as $R ^ { 2 }$ ). In addition, it is important to conduct an extra set of analyses, often referred to as publication bias tests, which are a type of sensitivity analysis [11], to check the robustness of metaanalytic results.

Table 1 Defnitions of key concepts and associated statistical parameters, which are used in formulas in the main text   

<html><body><table><tr><td>Term</td><td>Definition (with associated parameters, if any)</td></tr><tr><td>Effect size</td><td>Ameasurementofeffect (usuallystateofasingle group,comparisonbetweengroups,orassociation,seeTable2).Inameta- analytic model, it becomes the response variable (noted as zi in the formulas)</td></tr><tr><td>Sampling variance</td><td>Ameasureofuncertaintyinefectsize(notedasv).Itsinverseisoftencalledweight(thesquare-rootofweightisprecisionand the square root of sampling variance is &#x27;sampling standard error&#x27;)</td></tr><tr><td>Meta-analysis</td><td>Astatistical methodtoaggegateeffectsizesfromstudiesonthesameorsimilartopics,byassigningdiferent weightsbasedon samplingvarianceofefectsizesStrictlyspeaing,inaformal(weighted)metaanalysis,ampingvarianceneedstobeop rated and it is assumed to be known (Table 2)</td></tr><tr><td></td><td>Overalmean (efect)Anaverage effectsize basedonameta-analytic model (notedas βoanditsstandard erors,se(βo)</td></tr><tr><td>Heterogeneity</td><td>Anindicatorofconsistencyamongeffctsizes,oranextentofvariationaroundtheoveralleffect (βo);heterogeneitycanbe quantified by absolute measures, such as τ²,or relative measures,such as /²</td></tr><tr><td>Meta-regression</td><td>Aregressionmodelwhichextendsameta-analyticmodelwithamoderator(s),aimingtoexplain heterogeneity(quantifedasR) and quantifying the effect of a moderator (noted as,for example, β)</td></tr><tr><td></td><td>Publictiatioolotedobsi likely to be published and presentin the meta-analytic dataset than otherwise</td></tr><tr><td>Sensitivity analysis</td><td>Asetofstatitcalanalysesthatcheckstherobustnessfone&#x27;smainanalysis;ifsensitivityanalysisshowsdiferentresultsqualita tively and/or quantitively), then we must doubt the robustness of the main findings</td></tr></table></body></html>

# Choosing an efect size measure

In this section, we introduce diferent kinds of ‘efect size measures’ or ‘efect measures’. In the literature, the term ‘efect size’ is typically used to refer to the magnitude or strength of an efect of interest or its biological interpretation (e.g., environmental signifcance). Efect sizes can be quantifed using a range of measures (for details, see [22]). In our survey of environmental metaanalyses (Additional fle 1), the two most commonly used efect size measures are: the logarithm of response ratio, lnRR ([23]; also known as the ratio of means; [24]) and standardized mean diference, SMD (often referred to as Hedges’ $g$ or Cohen’s $d$ [25, 26]). Tese are followed by proportion $( \% )$ and Fisher’s $z$ -transformation of correlation, or $Z r$ . Tese four efect measures nearly ft into the three categories, which are named: (1) single-group measures (a statistical summary from one group; e.g., proportion), (2) comparative measures (comparing between two groups e.g., SMD and lnRR), and (3) association measures (relationships between two variables; e.g., $Z r )$ . Table  2 summarizes efect measures that are common or potentially useful for environmental scientists. It is important to note that any measures with sampling variance can become an ‘efect size’. Te main reason why SMD, lnRR, $Z r$ or proportion are popular efect measures is that they are unitless, while a meta-analysis of mean, or mean diference, can only be conducted when all efect sizes have the same unit (e.g., cm, kg).

Table  2 also includes efect measures that are likely to be unfamiliar to environmental scientists; these are efect sizes that characterise diferences in the observed variability between samples, (i.e., lnSD, lnCV, lnVR and lnCVR; [27, 28]) rather than central tendencies (averages). Tese dispersion-based efect measures can provide us with extra insights along with average-based efect measures. Although the literature survey showed none of these were used in our sample, these efect sizes have been used in many felds, including agriculture (e.g., [29]), ecology (e.g., [30]), evolutionary biology (e.g., [31]), psychology (e.g., [32]), education (e.g., [33]), psychiatry (e.g., [34]), and neurosciences (e.g. [35],),. Perhaps, it is not difcult to think of an environmental intervention that can afect not only the mean but also the variance of measurements taken on a group of individuals or a set of plots. For example, environmental stressors such as pesticides and eutrophication are likely to increase variability in biological systems because stress accentuates individual diferences in environmental responses (e.g. [36, 37],). Such ideas are yet to be tested meta-analytically (cf. [38, 39]).

# Choosing a meta‑analytic model

# Fixed‑efect and random‑efects models

Two traditional meta-analytic models are called the ‘fxed-efect’ model and the ‘random-efects’ model. Te former assumes that all efect sizes (from diferent studies) come from one population (i.e., they have one true overall mean), while the latter does not have such an assumption (i.e., each study has diferent overall means or heterogeneity exists among studies; see below for more). Te fxed-efect model, which should probably be more correctly referred to as the ‘common-efect’ model, can be written as [9, 10, 40]:

Table 2 Selected list of efect size measures and their sampling variances, belonging to three types: (1) single-group efect, (2) comparative efect and (3) association efect   

<html><body><table><tr><td>Type</td><td>Effect size</td><td>Point estimate</td><td></td><td>Sampling variance estimate</td><td></td><td>Reference</td></tr><tr><td>Single group</td><td>Mean</td><td>Xi</td><td></td><td>s2/ni</td><td></td><td>[134]</td></tr><tr><td>Single group</td><td>Proportion</td><td>pi=</td><td></td><td>pi(1-pi）=yi(ni-yi) ni</td><td></td><td>[134]</td></tr><tr><td>Single group</td><td>Log standard deviation (InSD)</td><td>Insi</td><td></td><td>1 2(ni-1)</td><td>m</td><td>[27]</td></tr><tr><td>Single group</td><td>Log coefficient of variation (InCV)</td><td>In(）</td><td></td><td>丽</td><td>1 +2（ni-1)</td><td>[27]</td></tr><tr><td>Comparative</td><td>Mean difference (MD)</td><td>XiT-XiC</td><td></td><td>+路</td><td></td><td>[134]</td></tr><tr><td>Comparative</td><td>Standardised mean difference (SMD)</td><td>di=</td><td>-</td><td>nic +</td><td>+ 20nc+m</td><td>[25]</td></tr><tr><td>Comparative</td><td>Risk (proportion) diference (RD)</td><td>√</td><td>nic+niT</td><td></td><td></td><td>[134]</td></tr><tr><td>Comparative</td><td>Log odds ratio (InOR)</td><td></td><td></td><td>+n-y+</td><td>+nc-yic</td><td>[134]</td></tr><tr><td>Comparative</td><td>Log response ratio (InRR)</td><td></td><td>-In(n）</td><td>+</td><td></td><td>[135]</td></tr><tr><td>Comparative</td><td>Log variability ratio (InVR)</td><td>n(）</td><td></td><td>nicx 1</td><td>niX 1</td><td></td></tr><tr><td>Comparative</td><td>Log coeficient of variation ratio (InCVR)</td><td>In(）</td><td></td><td></td><td>2(nic-1)+2（niT-1)</td><td>[27] [27]</td></tr><tr><td></td><td></td><td></td><td>n(）-In(）</td><td></td><td>+++</td><td></td></tr><tr><td>Association</td><td>Fisher&#x27;sz-transformation ofcorrelation,r (Z)</td><td>(）</td><td></td><td>1 ni-3</td><td></td><td>[134]</td></tr></table></body></html>

For the column 3rd and 4th, notations represent: x (mean), s (standard deviation), $n$ (sampling size), y (the number of events), the subscript $\tau$ (treatment group), the subscript C (control group) and the subscript i (the ith efect size or study) Note that better estimators may be found in the relevant references; for example, SMD can be best estimated by multiplying by − 3 4(niC +niT −2)−1 , and see also [43]

$$
z _ { j } = \beta _ { 0 } + m _ { j } ,
$$

$$
m _ { j } \sim \mathrm { N } \big ( 0 , \nu _ { j } \big ) ,
$$

where the intercept, $\beta _ { 0 }$ is the overall mean, $z _ { j }$ (the response/dependent variable) is the efect size from the jth study $( j = 1 , \ 2 , . . . , \ N _ { s t u d y ^ { \dagger } }$ in this model, $N _ { s t u d y } =$ the number of studies $=$ the number of efect sizes), $m _ { j }$ is the sampling error, related to the jth sampling variance $( \nu _ { j } )$ , which is normally distributed with the mean of 0 and the ‘study-specifc’ sampling variance, $\nu _ { j }$ (see also Fig. 1A).

Te overall mean needs to be estimated and often done so as the weighted average with the weights, $w _ { j } = 1 / \nu _ { j }$ (i.e., the inverse-variance approach). An important, but sometimes untenable, assumption of meta-analysis is that sampling variance is known. Indeed, we estimate sampling variance, using formulas, as in Table 2, meaning that vj is submitted by sampling variance estimates (see also section ‘Scale dependence’). Of relevance, the use of the inverse-variance approach has been recently criticized, especially for SMD and lnRR [41, 42] and we note that the inverse-variance approach using the formulas in Table  2 is one of several diferent weighting approaches used in meta-analysis (e.g., for adjusted sampling-variance weighing, see [43, 44]; for samplesize-based weighting, see [41, 42, 45, 46]). Importantly, the fxed-efect model assumes that the only source of variation in efect sizes $( z _ { j } )$ is the efect due to sampling variance (which is inversely proportional to the sample size, $n$ ; Table 2).

Similarly, the random-efects model can be expressed as:

$$
z _ { j } = \beta _ { 0 } + u _ { j } + m _ { j } ,
$$

$$
u _ { j } \sim \mathrm { N } \Big ( 0 , \tau ^ { 2 } \Big ) , \& m _ { j } \sim \mathrm { N } \big ( 0 , \nu _ { j } \big ) ,
$$

where $u _ { j }$ is the jth study efect, which is normally distributed with the mean of 0 and the between-study variance, $\tau ^ { 2 }$ (for diferent estimation methods, see [47–50]), and other notations are the same as in Eq.  1 (Fig.  1B). Here, the overall mean can be estimated as the weighted average with weights $w _ { j } = 1 / \left( \tau ^ { 2 } + \nu _ { j } ^ { 2 } \right)$ (note that diferent weighting approaches, mentioned above, are applicable to the random-efects model and some of them are to the multilevel model, introduced below). Te model assumes each study has its specifc mean, $b _ { 0 } + u _ { j }$ , and (in)consistencies among studies (efect sizes) are indicated by $\tau ^ { 2 }$ . When $\tau ^ { 2 }$ is 0 (or not statistically diferent from 0), the random-efects model simplifes to the fxed-efect model (cf. Equations 1 and 2). Given no studies in environmental sciences are conducted in the same manner or even at exactly the same place and time, we should expect diferent studies to have diferent means. Terefore, in almost all cases in the environmental sciences, the randomefects model is a more ‘realistic’ model [9, 10, 40]. Accordingly, most environmental meta-analyses $( 6 8 . 5 \%$

![](images/475c9a1ad1aa4dc7ae162bfc7a27b9ba6b88d841d28c54791256a9cd10894ba5.jpg)  
Fig. 1 Visualisation of the three statistical models of meta-analysis: A a fxed-efect model (1-level), B a random-efects model (2-level), and C a multilevel model (3-level; see the text for what symbols mean)

50 out of 73 studies) in our survey used the randomefects model, while only $2 . 7 \%$ (2 of 73 studies) used the fxed-efect model (Additional fle 1).

# Multilevel meta‑analytic models

Although we have introduced the random-effects model as being more realistic than the fixed-effect model (Eq. 2), we argue that the random-effects model is rather limited and impractical for the environmental sciences. This is because random-effects models, like fixed-effect models, assume all effect sizes $( z _ { j } )$ to be independent. However, when multiple effect sizes are obtained from a study, these effect sizes are dependent (for more details, see the next section on non-independence). Indeed, our survey showed that in almost all datasets used in environmental meta-analyses, this type of non-independence among effect sizes occurred $( 9 7 . 3 \%$ ; 71 out of 73 studies, with two studies being unclear, so effectively $1 0 0 \%$ ; Additional file  1). Therefore, we propose the simplest and most practical metaanalytic model for environmental sciences as [13, 40] (see also [51, 52]):

$$
z _ { i } = \beta _ { 0 } + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

$$
u _ { j } \sim \mathrm { N } \Big ( 0 , \tau ^ { 2 } \Big ) , e _ { i } \sim \mathrm { N } \Big ( 0 , \sigma ^ { 2 } \Big ) , \& m _ { i } \sim \mathrm { N } ( 0 , \nu _ { i } )
$$

where we explicitly recognize that $N _ { e f f e c t } \ ( i = 1 , 2 , . . . , N _ { e f } .$ $_ { f e c t } ) > N _ { s t u d y } ( j = 1 , \ 2 , . . . , \ N _ { s t u d y } )$ and, therefore, we now have the study efect (between-study efect), $u _ { \mathrm { j [ i ] } }$ (for the jth study and ith efect size) and efect-size level (within-study) efect, $e _ { i }$ (for the ith efect size), with the between-study variance, $\tau ^ { 2 }$ , and with-study variance, $\sigma ^ { 2 }$ , respectively, and other notations are the same as above. We note that this model (Eq.  3) is an extension of the random-efects model (Eq.  2), and we refer to it as the multilevel/hierarchical model (used in 7 out of 73 studies: $9 . 6 \%$ [Additional fle 1]; note that Eq. 3 is also known as a three-level meta-analytic model; Fig. 1C). Also, environmental scientists who are familiar with (generalised) linear mixed-models may recognize $u _ { j }$ (the study efect) as the efect of a random factor which is associated with a variance component, i.e., $\tau ^ { 2 }$ [53]; also, $e _ { i }$ and $m _ { i }$ can be seen as parts of random factors, associated with $\sigma ^ { 2 }$ and $\nu _ { i }$ (the former is comparable to the residuals, while the latter is sampling variance, specifc to a given efect size).

It seems that many researchers are aware of the issue of non-independence so that they often use average effect sizes per study or choose one effect size (at least $2 8 . 8 \%$ , 21 out of 73 environmental meta-analyses; Additional file 1). However, as we discussed elsewhere [13, 40], such averaging or selection of one effect size per study dramatically reduces our ability to investigate environmental drivers of variation among effect sizes [13]. Therefore, we strongly support the use of the multilevel model. Nevertheless, this proposed multilevel model, formulated as Eq. 3 does not usually deal with the issue of non-independence completely, which we elaborate on in the next section.

# Non‑independence among efect sizes and among sampling errors

When you have multiple efect sizes from a study, there are two broad types and three cases of nonindependence (cf. [11, 12]): (1) efect sizes are calculated from diferent cohorts of individuals (or groups of plots) within a study (Fig. 2A, referred to as ‘shared study identity’), and (2) efects sizes are calculated from the same cohort of individuals (or group of plots; Fig.  2B, referred to as ‘shared measurements’) or partially from the same individuals and plots, more concretely, sharing individuals and plots from the control group (Fig.  2C, referred to as ‘shared control group’). Te frst type of non-independence induces dependence among efect sizes, but not among sampling variances, and the second type leads to non-independence among sampling variances. Many datasets, if not almost all, will have a combination of these three cases (or even are more complex, see the section "Complex non-independence"). Failing to deal with these nonindependences will infate Type 1 error (note that the overall estimate, $b _ { 0 }$ is unlikely to be biased, but standard error of $b _ { 0 } \mathrm { . }$ , $\mathsf { s e } ( b _ { 0 } )$ , will be underestimated; note that this is also true for all other regression coefcients, e.g., $b _ { 1 } ;$ see Table 1). Te multilevel model (as in Eq. 3) only takes care of cases of non-independence that are due to the shared study identity but neither shared measurements nor shared control group.

![](images/98baeaa91168fb6f83debcee67ccf77a550d1a06cca0b9ee41d467196204cf54.jpg)  
Fig. 2 Visualisation of the three types of non-independence among efect sizes: A due to shared study identities (efect sizes from the same study), B due to shared measurements (efect sizes come from the same group of individuals/plots but are based on diferent types of measurements), and C due to shared control (efect sizes are calculated using the same control group and multiple treatment groups; see the text for more details)

Tere are two practical ways to deal with non-independence among sampling variances. Te frst method is that we explicitly model such dependence using a variance–covariance (VCV) matrix (used in 6 out of 73 studies: $8 . 2 \%$ ; Additional fle  1). Imagine a simple scenario with a dataset of three efect sizes from two studies where two efects sizes from the frst study are calculated (partially) using the same cohort of individuals (Fig. 2B); in such a case, the sampling variance efect, $m _ { i }$ , as in Eq. 3, should be written as:

$$
m _ { i } \sim \mathrm { N } ( 0 , \mathbf { M } )
$$

$$
\mathbf { M } = \left[ \rho \sqrt { \nu _ { 1 [ 1 ] } { \nu _ { 1 [ 1 ] } } } \begin{array} { c c c } { \rho \sqrt { \nu _ { 1 [ 1 ] } \nu _ { 1 [ 2 ] } } } & { 0 } \\ { \nu _ { 1 [ 2 ] } } & { 0 } \\ { 0 } & { 0 } & { \nu _ { 2 [ 3 ] } } \end{array} \right] ,
$$

where $\mathbf { M }$ is the VCV matrix showing the sampling variances, $, \nu _ { 1 [ 1 ] }$ (study 1 and efect size 1), $\nu _ { 1 [ 2 ] }$ (study 1 and efect size 2), and $\nu _ { 2 [ 3 ] }$ (study 2 and efect size 3) in its diagonal, and sampling covariance, $\rho \sqrt { \nu _ { 1 [ 1 ] } \nu _ { 1 [ 2 ] } } = \rho \sqrt { \nu _ { 1 [ 2 ] } \nu _ { 1 [ 1 ] } }$ in its of-diagonal elements, where $\rho$ is a correlation between two sampling variances due to shared samples (individuals/plots). Once this VCV matrix is incorporated into the multilevel model (Eq. 3), all the types of non-independence, as in Fig. 2, are taken care of. Table 3 shows formulas for the sampling variance and covariance of the four common efect sizes (SDM, lnRR, proportion and $Z r$ ). For comparative efect measures (Table 2), exact covariances can be calculated under the case of ‘shared control group’ (see [54, 55]). But this is not feasible for most circumstances because we usually do not know what $\rho$ should be. Some have suggested fxing this value at 0.5 (e.g., [11]) or 0.8 (e.g., [56]); the latter is a more conservative assumption. Or one can run both and use one for the main analysis and the other for sensitivity analysis (for more, see the ‘Conducting sensitivity analysis and critical appraisal" section).

Table 3 Examples of dependence between two sampling variances $( v _ { 1 }$ and $V _ { 2 } )$ and their covariance for four common efect size statistics   

<html><body><table><tr><td>Effect size</td><td>Situation</td><td colspan="4">Variances estimate</td><td>Covariance estimate</td></tr><tr><td>Proportion</td><td>Shared measurement</td><td>V1= y(n1-/1）</td><td></td><td></td><td>P1</td><td>y1(n1-y1） y2(n2-y2）</td></tr><tr><td></td><td></td><td>v = y2</td><td>m</td><td></td><td></td><td></td></tr><tr><td>Zr</td><td>Shared measurement</td><td>V1=</td><td></td><td>1+</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td>1-1</td><td></td><td>(（）</td></tr><tr><td></td><td></td><td>V2=</td><td>n</td><td>1+12 1-r2</td><td></td><td></td></tr><tr><td>InRR</td><td>Shared measurement</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>V1=</td><td>m</td><td></td><td></td><td>3</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>+ m2c +</td></tr><tr><td></td><td></td><td>V=</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>nc2</td><td></td><td>+n</td><td></td></tr><tr><td></td><td>Shared control</td><td>V1=</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>ncic</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>sic</td><td></td><td>+</td><td></td></tr><tr><td></td><td></td><td>v=n+</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>SMD</td><td>Shared measurement</td><td></td><td></td><td>1</td><td></td><td></td></tr><tr><td></td><td></td><td>V1=</td><td>n1c</td><td></td><td>+ 2(n1c+n17)</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td>mc+m+2nc+n））</td></tr><tr><td></td><td></td><td>v2=nc++2）</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>+ 20ic+17+P7</td><td>nc+ 2(n1c++27）</td></tr><tr><td></td><td>Shared control</td><td></td><td>1</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>V1=</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>mc</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td>+</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td>1</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>V =nc</td><td></td><td>+n+ 2(nc++n7）</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td></table></body></html>

For the 2nd column, see Fig. 2. For the 3rd and 4th column, notations represent: the subscript 1C and 2C (control group for 1st and 2nd efect size, respectively, but for shared control, 1C is used for both efect sizes, but 1C and 2C are the same cohort or set of plots), the subscript 1T and 2T (treatment group for the 1st and 2nd efect size, respectively; for shared groups, 1T and 2T represents diferent groups of individuals/plots whereas, for shared measurements, 1T and 2T are the same set of individuals/ plots), $\rho$ is a correlation in sampling error variance between two measurements, and the other notations are as in Table 1 and the main text (see also [54, 55])

Te second method overcomes this very issue of unknown $\rho$ by approximating average dependence among sampling variance (and efect sizes) from the data and incorporating such dependence to estimate standard errors (only used in 1 out of 73 studies; Additional fle  1). Tis method is known as ‘robust variance estimation’, RVE, and the original estimator was proposed by Hedges and colleagues in 2010 [57]. Meta-analysis using RVE is relatively new, and this method has been applied to multilevel metaanalytic models only recently [58]. Note that the randomefects model (Eq. 2) and RVE could correctly model both types of non-independence. However, we do not recommend the use of RVE with Eq.  2 because, as we will later show, estimating $\sigma ^ { 2 }$ as well as $\tau ^ { 2 }$ will constitute an important part of understanding and gaining more insights from one’s data. We do not yet have a defnite recommendation on which method to use to account for non-independence among sampling errors (using the VCV matrix or RVE). Tis is because no simulation work in the context of multilevel meta-analysis has been done so far, using multilevel meta-analyses [13, 58]. For now, one could use both VCV matrices and RVE in the same model [58] (see also [21]).

# Quantifying and explaining heterogeneity Measuring consistencies with heterogeneity

As mentioned earlier, quantifying heterogeneity among efect sizes is an essential component of any meta-analysis. Yet, our survey showed only 28 out of 73 environmental meta-analyses $( 3 8 . 4 \%$ ; Additional fle 1) report at least one index of heterogeneity (e.g., $\tau ^ { 2 } , \ Q ,$ and $\scriptstyle { I ^ { 2 } } .$ ). Conventionally, the presence of heterogeneity is tested by Cochrane’s $Q$ test. However, $Q$ (often noted as $Q _ { T }$ or $Q _ { t o t a l } )$ , and its associated $p$ value, are not particularly informative: the test does not tell us about the extent of heterogeneity (e.g. [10],), only whether heterogeneity is zero or not (when $p { < } 0 . 0 5 )$ . Terefore, for environmental scientists, we recommend two common ways of quantifying heterogeneity from a meta-analytic model: absolute heterogeneity measure (i.e., variance components, $\tau ^ { 2 }$ and $\sigma ^ { 2 }$ ) and relative heterogeneity measure (i.e., $I ^ { 2 }$ ; see also the "Notes on visualisation and interpretation" section for another way of quantifying and visualising heterogeneity at the same time, using prediction intervals; see also [59]). We have already covered the absolute measure (Eqs. 2 & 3), so here we explain $I ^ { 2 }$ , which ranges from 0 to 1 (for some caveats for $I ^ { 2 }$ , see [60, 61]). Te heterogeneity measure, $\hat { I } ^ { 2 }$ , for the random-efect model (Eq. 2) can be written as:

$$
I ^ { 2 } = \frac { \tau ^ { 2 } } { \tau ^ { 2 } + \bar { \nu } } ,
$$

$$
\overline { { \nu } } = \frac { \left( N _ { e f f e c t } - 1 \right) \sum _ { j = 1 } ^ { k } \left( 1 / \nu _ { i } \right) } { \left( \sum _ { j = 1 } ^ { k } \left( 1 / \nu _ { i } \right) \right) ^ { 2 } - \sum _ { j = 1 } ^ { k } \left( 1 / \nu _ { i } \right) ^ { 2 } } ,
$$

Where $\bar { \nu }$ is referred to as the typical sampling variance (originally this is called ‘within-study’ variance, as in Eq.  2, and note that in this formulation, within-study efect and the efect of sampling error is confounded; see [62, 63]; see also [64]) and the other notations are as above. As you can see from Eq. 5, we can interpret $I ^ { 2 }$ as relative variation due to diferences between studies (between-study variance) or relative variation not due to sampling variance.

By seeing $I ^ { 2 }$ as a type of interclass correlation (also known as repeatability [65],), we can generalize $\hat { I } ^ { 2 }$ to multilevel models. In the case of Eq. 3 ([40, 66]; see also [52]), we have:

$$
I _ { t o t a l } ^ { 2 } = \frac { \tau ^ { 2 } + \sigma ^ { 2 } } { \tau ^ { 2 } + \sigma ^ { 2 } + \overline { { { \nu } } } }
$$

Because we can have two more $I ^ { 2 }$ , Eq. 7 is written as $I _ { t o t a l } ^ { 2 } \dot { \mathbf { \Omega } }$ these other two are $I _ { s t u d y } ^ { 2 }$ and I 2effect, respectively:

$$
I _ { s t u d y } ^ { 2 } = \frac { \tau ^ { 2 } } { \tau ^ { 2 } + \sigma ^ { 2 } + \overline { { { \nu } } } } ,
$$

$$
I _ { e f f e c t } ^ { 2 } = \frac { \sigma ^ { 2 } } { \tau ^ { 2 } + \sigma ^ { 2 } + \overline { { { \nu } } } }
$$

$I _ { t o t a l } ^ { 2 }$ represents relative variance due to diferences both between and within studies (between- and within-study variance) or relative variation not due to sampling variance, while $I _ { s t u d y } ^ { 2 }$ is relative variation due to diferences between studies, and $I _ { e f f e c t } ^ { 2 }$ is relative variation due to diferences within studies (Fig.  3A). Once heterogeneity is quantifed (note almost all data will have non-zero heterogeneity and an earlier meta-meta-analysis suggests in ecology, we have on average, $I ^ { 2 }$ close to $9 0 \%$ [66]), it is time to ft a metaregression model to explain the heterogeneity. Notably, the magnitude of $I _ { s t u d y } ^ { 2 }$ (and $\tau ^ { 2 }$ ) and $I _ { e f f e c t } ^ { 2 }$ (and $\sigma ^ { 2 }$ ) can already inform you which predictor variable (usually referred to as ‘moderator’) is likely to be important, which we explain in the next section.

# Explaining variance with meta‑regression

We can extend the multilevel model (Eq.  3) to a metaregression model with one moderator (also known as predictor, independent, explanatory variable, or fxed factor), as below:

![](images/6ec4b28d5a8b9e106bf74d9c9993935df0a0106395d6a2472b51a1b87ec2fccf.jpg)  
Fig. 3 Visualisation of variation (heterogeneity) partitioned into diferent variance components: A quantifying diferent types of $I ^ { 2 }$ from a multilevel model (3-level; see Fig. 1C) and B variance explained, $R ^ { 2 }$ , by moderators. Note that diferent levels of variances would be explained, depending on which level a moderator belongs to (study level and efect-size level)

$$
z _ { i } = \beta _ { 0 } + \beta _ { 1 } x _ { 1 j [ i ] } + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

where $\beta _ { 1 }$ is a slope of the moderator $( x _ { 1 } ) , x _ { 1 j [ i ] }$ denotes the value of $x _ { 1 } ,$ corresponding to the jth study (and the ith efect sizes). Equation (10) (meta-regression) is comparable to the simplest regression with the intercept $( \beta _ { 0 } )$ and slope $( \beta _ { 1 } )$ . Notably, $x _ { 1 j [ i ] }$ difers between studies and, therefore, it will mainly explain the variance component, $\tau ^ { 2 }$ (which relates to $I _ { s t u d y } ^ { 2 } )$ . On the other hand, if noted like $x _ { 1 i }$ this moderator would vary within studies or at the level of efect sizes, therefore, explaining $\sigma ^ { 2 }$ (relating to $I _ { e f f e c t } ^ { 2 } )$ . Terefore, when $\tau ^ { 2 } ( I _ { s t u d y } ^ { 2 } )$ , or $\sigma ^ { 2 } ( \bar { I _ { e f f e c t } ^ { 2 } } )$ , is close to zero, there will be little point ftting a moderator(s) at the level of studies, or efect sizes, respectively.

As in multiple regression, we can have multiple (multimoderator) meta-regression, which can be written as:

$$
z _ { i } = \beta _ { 0 } + \sum _ { h = 1 } ^ { q } \beta _ { h } x _ { h \left[ i \right] } + u _ { j \left[ i \right] } + e _ { i } + m _ { i } ,
$$

where $\scriptstyle \sum _ { h = 1 } ^ { q } \beta _ { h } x _ { h [ i ] }$ denotes the sum of all the moderator efects, with $q$ being the number of slopes (staring with $h = 1$ ). We note that $q$ is not necessarily the number of moderators. Tis is because when we have a categorical moderator, which is common, with more than two levels (e.g., method A, B & C), the fxed efect part of the formula is $\beta _ { 0 } + \beta _ { 1 } x _ { 1 } + \beta _ { 2 } x _ { 2 } ,$ where $x _ { 1 }$ and $x _ { 2 }$ are ‘dummy’ variables, which code whether the ith efect size belongs to, for example, method B or $C$ , with $\beta _ { 1 }$ and $\beta _ { 2 }$ being contrasts between A and B and between A and C, respectively (for more explanations of dummy variables, see our tutorial page [https://itchyshin.github.io/ Meta-analysis_tutorial/]; also see [67, 68]). Traditionally, researchers conduct separate meta-analyses per diferent groups (known as ‘sub-group analysis’), but we prefer a meta-regression approach with a categorical variable, which is statistically more powerful [40]. Also, importantly, what can be used as a moderator(s) is very fexible, including, for example, individual/plot characteristics (e.g., age, location), environmental factors (e.g., temperature), methodological diferences between studies (e.g., randomization), and bibliometric information (e.g., publication year; see more in the section ‘Checking for publication bias and robustness’). Note that moderators should be decided and listed a priori in the meta-analysis plan (i.e., a review protocol or pre-registration).

As with meta-analysis, the $Q$ -test ( $\textstyle \left[ Q _ { m } \right]$ or $Q _ { m o d e r a t o r } )$ is often used to test the signifcance of the moderator(s). To complement this test, we can also quantify variance explained by the moderator(s) using $R ^ { 2 }$ . We can defne $R ^ { 2 }$ using Eq. (11) as:

$$
R ^ { 2 } = \frac { f ^ { 2 } } { f ^ { 2 } + \tau ^ { 2 } + \sigma ^ { 2 } } ,
$$

$$
f ^ { 2 } = \mathrm { V a r } \left( \sum _ { h = 1 } ^ { q } \beta _ { h } x _ { h [ i ] } \right) ,
$$

where $R ^ { 2 }$ is known as marginal $R ^ { 2 }$ (sensu [69, 70]; cf. [71]), $f ^ { 2 }$ is the variance due to the moderator(s), and $( f ^ { 2 } + \tau ^ { 2 } + \sigma ^ { 2 } )$ here equals to $( \tau ^ { 2 } + \sigma ^ { 2 } )$ in Eq.  7, as $f ^ { 2 }$ ‘absorbs’ variance from $\tau ^ { 2 }$ and/or $\sigma ^ { 2 }$ . We can compare the similarities denote a part of $f ^ { 2 }$ d diferences in originating from $\tau ^ { 2 }$ g.   as $f _ { s t u d y } ^ { 2 }$ here  while $\sigma ^ { 2 }$ as $f _ { e f f e c t } ^ { 2 }$ . In a multiple meta-regression model, we often want to fnd a model with the ‘best’ or an adequate set of predictors (i.e., moderators). $R ^ { 2 }$ can potentially help such a model selection process. Yet, methods based on information criteria (such as Akaike information criterion, AIC) may be preferable. Although model selection based on the information criteria is beyond the scope of the paper, we refer the reader to relevant articles (e.g., [72, 73]), and we show an example of this procedure in our online tutorial (https://itchyshin.github.io/Meta-analy sis_tutorial/).

# Notes on visualisation and interpretation

Visualization and interpretation of results is an essential part of a meta-analysis [74, 75]. Traditionally, a forest plot is used to display the values and $9 5 \%$ of confdence intervals (CIs) for each efect size and the overall efect and its $9 5 \%$ CI (the diamond symbol is often used, as shown in Fig. 4A). More recently, adding a $9 5 \%$ prediction interval (PI) to the overall estimate has been strongly recommended because $9 5 \%$ PIs show a predicted range of values in which an efect size from a new study would fall, assuming there is no sampling error [76]. Here, we think that examining the formulas for $9 5 \%$ CIs and PIs for the overall mean (from Eq. 3) is illuminating:

$$
9 5 \% \mathrm { C I } = \beta _ { 0 } \pm t _ { d f [ \alpha = 0 . 0 5 ] } s e ( \beta _ { 0 } ) ,
$$

$$
9 5 \% \mathrm { P I } = \beta _ { 0 } \pm t _ { d f [ \alpha = 0 . 0 5 ] } \sqrt { s e ^ { 2 } ( \beta _ { 0 } ) + \tau ^ { 2 } + \sigma ^ { 2 } } ,
$$

where $t _ { d f [ \alpha = 0 . 0 5 ] }$ denotes the $t$ value with the degree of freedom, $d f ,$ at 97.5 percentile (or $\alpha = 0 . 0 5$ ) and other notations are as above. In a meta-analysis, it has been conventional to use $z$ value 1.96 instead of $t _ { d f [ \alpha = 0 . 0 5 ] } ,$ but simulation studies have shown the use of $t$ value over $z$ value reduces Type 1 errors under many scenarios and, therefore, is recommended (e.g., [13, 77]). Also, it is interesting to note that by plotting $9 5 \%$ PIs, we can visualize heterogeneity as Eq. 15 includes $\tau ^ { 2 }$ and $\sigma ^ { 2 }$ .

A ‘forest’ plot can become quickly illegible as the number of studies (efect sizes) becomes large, so other methods of visualizing the distribution of efect sizes have been suggested. Some suggested to present a ‘caterpillar’ plot, which is a version of the forest plot, instead (Fig. 4B; e.g., [78]). We here recommend an ‘orchard’ plot, as it can present results across diferent groups (or a result of meta-regression with a categorical variable), as shown in Fig.  4C [78]. For visualization of a continuous variable, we suggest what is called a ‘bubble’ plot, shown in Fig.  4D. Visualization not only helps us interpret metaanalytic results, but can also help to identify something we may not see from statistical results, such as infuential data points and outliers that could threaten the robustness of our results.

# Checking for publication bias and robustness Detecting and correcting for publication bias

Checking for and adjusting for any publication bias is necessary to ensure the validity of meta-analytic inferences [79]. However, our survey showed almost half of the environmental meta-analyses ( $4 6 . 6 \%$ ; 34 out of 73 studies; Additional fle 1) neither tested for nor corrected for publication bias (cf. [14–16]). Te most popular methods used were: (1) graphical tests using funnel plots (26 studies; $3 5 . 6 \%$ ), (2) regression-based tests such as Egger regression (18 studies; $2 4 . 7 \%$ ), (3) Fail-safe number tests (12 studies; $1 6 . 4 \%$ ), and (4) trim-and-fll tests (10 studies; $1 3 . 7 \%$ . We recently showed that these methods are unsuitable for datasets with non-independent efect sizes, with the exception of funnel plots [80] (for an example of funnel plots, see Fig. 5A). Tis is because these methods cannot deal with non-independence in the same way as the fxed-efect and random-efects models. Here, we only introduce a two-step method for multilevel models that can both detect and correct for publication bias [80] (originally proposed by [81, 82]), more specifcally, the “small study efect” where an efect size value from a small-sample-sized study can be much larger in magnitude than a ‘true’ efect [83, 84]. Tis method is a simple extension of Egger’s regression [85], which can be easily implemented by using Eq. 10:

![](images/46c143ff5b7014fb291a864ba6800e4e3f4fa0b60888dead4ec3b5a421ab9f03.jpg)  
Fig. 4 Diferent types of plots useful for a meta-analysis using data from Midolo et al. [133]: A a typical forest plot with the overall mean shown as a diamond at the bottom (20 efect sizes from 20 studies are used), B a caterpillar plot (100 efect sizes from 24 studies are used), C an orchard plot of categorical moderator with seven levels (all efect sizes are used), and D a bubble plot of a continuous moderator. Note that the frst two only show confdence intervals, while the latter two also show prediction intervals (see the text for more details)

$$
z _ { i } = \beta _ { 0 } + \beta _ { 1 } \sqrt { \frac { 1 } { \widetilde { n } _ { i } } } + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

$$
z _ { i } = \beta _ { 0 } + \beta _ { 1 } \left( \frac { 1 } { \widetilde { n } _ { i } } \right) + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

![](images/f1509ef0579b9ede056a17e046cd22152e92cb7dc7fd5a24a37795d638082c76.jpg)  
Fig. 5 Diferent types of plots for publication bias tests: A a funnel plot using model residuals, showing a funnel (white) that shows the region of statistical non-signifcance (30 efect sizes from 30 studies are used; note that we used the inverse of standard errors for the $y .$ -axis, but for some efect sizes, sample size or ‘efective’ sample size may be more appropriate), B a bubble plot visualising a multilevel meta-regression that tests for the small study efect (note that the slope was non-signifcant: $b { = } 0 . 1 2 0$ , $9 5 \% \mathsf { C l } = [ - 0 . 0 9 5 ,$ , 0.334]; all efect sizes are used), and C a bubble plot visualising a multilevel meta-regression that tests for the decline efect (the slope was non-signifcant: $b { = } 0 . 0 0 3$ , $9 5 \% C | = [ - 0 . 0 0 2 , 0 . 0 0 8 ]$ )

where $\widetilde { n } _ { i }$ is known as efective sample size; for $Z r$ and proportion it is just $n _ { i } ,$ and for SMD and lnRR, it is $n _ { i C } n _ { i T } / ( n _ { i C } + n _ { i T } )$ , as in Table 2. When $\beta _ { 1 }$ is signifcant, we conclude there exists a small-study efect (in terms of a funnel plot, this is equivalent to signifcant funnel asymmetry). Ten, we ft Eq. 17 and we look at the intercept $\beta _ { 0 }$ , which will be a bias-corrected overall estimate [note that $\beta _ { 0 }$ in Eq. (16) provides less accurate estimates when non-zero overall efects exist [81, 82]; Fig. 5B]. An intuitive explanation of why $\beta _ { 0 }$ (Eq. 17) is the ‘bias-corrected’ estimate is that the intercept represents $1 / \widetilde { n _ { i } } = 0$ (or $\widetilde { n _ { i } } = \infty ,$ ); in other words, $\beta _ { 0 }$ is the estimate of the overall efect when we have a very large (infnite) sample size. Of note, appropriate bias correction requires a selectionmode-based approach although such an approach is yet to be available for multilevel meta-analytic models [80].

Conveniently, this proposed framework can be extended to test for another type of publication bias, known as time-lag bias, or the decline efect, where efect sizes tend to get closer to zero over time, as larger or statistically signifcant efects are published more quickly than smaller or non-statistically signifcant efects [86, 87]. Again, a decline efect can be statistically tested by adding year to Eq. (3):

$$
z _ { i } = \beta _ { 0 } + \beta _ { 1 } c \bigl ( y e a r _ { j [ i ] } \bigr ) + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

where $c \left( y e a r _ { j [ i ] } \right)$ is the mean-centred publication year of a particular study (study $j$ and efect size $i )$ ); this centring makes the intercept $\beta _ { 0 }$ meaningful, representing the overall efect estimate at the mean value of publication years (see [68]). When the slope is signifcantly diferent from 0, we deem that we have a decline efect (or time-lag bias; Fig. 5C).

However, there may be some confounding moderators, which need to be modelled together. Indeed, Egger’s regression (Eqs. 16 and 17) is known to detect the funnel asymmetry when there is little heterogeneity; this means that we need to model $\sqrt { 1 / \widetilde { n } _ { i } }$ with other moderators that account for heterogeneity. Given this, we probably should use a multiple meta-regression model, as below:

$$
z _ { i } = \beta _ { 0 } + \beta _ { 1 } \sqrt { \frac { 1 } { \widetilde { n } _ { i } } } + \beta _ { 2 } c \big ( y e a r _ { j [ i ] } \big ) + \sum _ { h = 3 } ^ { q } \beta _ { h } x _ { h [ i ] } + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

where $\scriptstyle \sum _ { h = 3 } ^ { q } \beta _ { h } x _ { h [ i ] }$ is the sum of the other moderator efects apart from the small-study efect and decline efect, and other notations are as above (for more details see [80]). We need to carefully consider which moderators should go into Eq. 19 (e.g., ftting all moderators or using an AIC-based model selection method; see [72, 73]). Of relevance, when running complex models, some model parameters cannot be estimated well, or they are not ‘identifable’ [88]. Tis is especially so for variance components (random-efect part) rather than regression coefects (fxed-efect part). Terefore, it is advisable to check whether model parameters are all identifable, which can be checked using the profle function in metafor (for an example, see our tutorial webpage [https:// itchyshin.github.io/Meta-analysis_tutorial/]).

# Conducting sensitivity analysis and critical appraisal

Sensitivity analysis explores the robustness of meta-analytic results by running a diferent set of analyses from the original analysis, and comparing the results (note that some consider publication bias tests a part of sensitivity analysis; [11]). For example, we might be interested in assessing how robust results are to the presence of infuential studies, to the choice of method for addressing non-independence, or weighting efect sizes. Unfortunately, in our survey, only $3 7 \%$ of environmental metaanalyses (27 out of 73) conducted sensitivity analysis (Additional fle 1). Tere are two general and interrelated ways to conduct sensitivity analyses [73, 89, 90]. Te frst one is to take out infuential studies (e.g., outliers) and re-run meta-analytic and meta-regression models. We can also systematically take each efect size out and run a series of meta-analytic models to see whether any resulting overall efect estimates are diferent from others; this method is known as ‘leave-one-out’, which is considered less subjective and thus recommended.

Te second way of approaching sensitivity analysis is known as subset analysis, where a certain group of efect sizes (studies) will be excluded to re-run the models without this group of efect sizes. For example, one may want to run an analysis without studies that did not randomize samples. Yet, as mentioned earlier, we recommend using meta-regression (Eq.  13) with a categorical variable of randomization status (‘randomized’ or ‘not randomized’), to statistically test for an infuence of moderators. It is important to note that such tests for risk of bias (or study quality) can be considered as a way of quantitatively evaluating the importance of study features that were noted at the stage of critical appraisal, which is an essential part of any systematic review (see [11, 91]). In other words, we can use meta-regression or subset analysis to quantitatively conduct critical appraisal using (study-level) moderators that code, for example, blinding, randomization, and selective reporting. Despite the importance of critical appraisal ([91]), only 4 of 73 environmental metaanalyses $( 5 . 6 \% )$ in our survey assessed the risk of bias in each study included in a meta-analysis (i.e., evaluating a primary study in terms of the internal validity of study design and reporting; Additional fle  1). We emphasize that critically appraising each paper or checking them for risk of bias is an extremely important topic. Also, critical appraisal is not restricted to quantitative synthesis. Terefore, we do not cover any further in this paper for more, see [92, 93]).

# Notes on transparent reporting and open archiving

For environmental systematic reviews and maps, there are reporting guidelines called RepOrting standards for Systematic Evidence Syntheses in environmental research, ROSES [94] and synthesis assessment checklist, the Collaboration for Environmental Evidence Synthesis Appraisal Tool (CEESAT; [95]). However, these guidelines are somewhat limited in terms of reporting quantitative synthesis because they cover only a few core items. Tese two guidelines are complemented by the Preferred Reporting Items for Systematic Reviews and Meta-Analyses for Ecology and Evolutionary Biology (PRISMA-EcoEvo; [96]; cf. [97, 98]), which provides an extended set of reporting items covering what we have described above. Items 20–24 from PRISMA-EcoEvo are most relevant: these items outline what should be reported in the Methods section: (i) sample sizes and study characteristics, (ii) meta-analysis, (iii) heterogeneity, (iv) meta-regression and (v) outcomes of publication bias and sensitivity analysis (see Table 4). Our survey, as well as earlier surveys, suggest there is a large room for improvement in the current practice ([14–16]). Incidentally, the orchard plot is well aligned with Item 20, as this plot type shows both the number of efect sizes and studies for diferent groups (Fig. 4C). Further, our survey of environmental meta-analyses highlighted the poor standards of data openness (with 24 studies sharing data: $3 2 . 9 \%$ ) and code sharing (7 studies: $2 9 . 2 \%$ ; Additional fle  1). Environmental scientists must archive their data as well as their analysis code in accordance with the FAIR principles (Findable, Accessible, Interoperable, and Reusable [99]) using dedicated depositories such as Dryad, FigShare, Open Science Framework (OSF), Zenodo or others (cf. [100, 101]), preferably not on publisher’s webpages (as paywall may block access). However, archiving itself is not enough; data requires metadata (detailed descriptions) and the code needs to also be FAIR [102, 103].

Table 4 Items relevant to reporting results for a meta-analysis from the Preferred Reporting Items for Systematic reviews and MetaAnalysis for Ecology and Evolutionary Biology (PRISMA-EcoEvo; [96])   

<html><body><table><tr><td>Item</td><td>Description</td></tr><tr><td>20: Sample sizes and study characteristics</td><td>“Reportthe number of studies and effect size for data included in meta-analyses and subsets of data included inmeta-regresions.Provide a summaryof kye characteristics for reported outcomes (either in textor figures; e.g,one quarterof efect sizes reported forvertebratesand the rest invertebrates)and their limitations (e.g.,collinearityand overlaps between moderators),including characteristics related individual</td></tr><tr><td>21: Meta-analysis</td><td>study quality (risk of bias).&quot; &quot;Provide a quantitative synthesis of results across studies,including estimates forthe main effect size,with confidence/credible intervals.&quot;</td></tr><tr><td>22: Heterogeneity</td><td>&quot;Report indicators of heterogeneityin the estimated effect (e.g.P,tau² and other variance components).&quot;</td></tr><tr><td>23: Meta-regression</td><td>&quot;Provide estimates of meta-regression slopes (i.e.regression coeficients)forallvariables that were assessed fortheircontribution to heterogeneity. Includeconfidence/credible intervals,and report interactions if they were included. Describe outcomes from model selection,if done (e.g. R² and AlC).&quot;</td></tr><tr><td>24: Outcomes of publication bias and sensitivity analysis</td><td>&quot;Provide results for the assessments of the risks of bias (e.g. Egger&#x27;s regression,funnel plots)and robustness ofthereview&#x27;s results (e.g.subgroupanalyses,meta-regression of study quality,results fromalternative methods of analysis,and temporal trends)&quot;</td></tr></table></body></html>

# Other relevant and advanced issues Scale dependence

Te issue of scale dependence is a unique yet widespread problem in environmental sciences (see [7, 104]); our literature survey indicated three quarters of the environmental meta-analyses (56 out of 73 studies) have inferences that are potentially vulnerable to scaledependence [105]. For example, studies that set out to compare group means in biodiversity measures, such as species richness, can vary as a function of the scale (size) of the sampling unit. When the unit of replication is a plot (not an individual animal or plant), the aerial size of a plot (e.g., $1 0 0 ~ \mathrm { c m } ^ { 2 }$ or $1 ~ \mathrm { k m } ^ { 2 } )$ will afect both the precision and accuracy of efect size estimates (e.g., lnRR and SMD). In general, a study with larger plots might have more accurately estimated species richness diferences, but less precisely than a study with smaller plots and greater replication. Lower replication means that our sampling variance estimates are likely to be misestimated, and the study with larger plots will generally have less weight than the study with smaller plots, due to higher sampling variance. Inaccurate variance estimates in little-replicated ecological studies are known to cause an accumulating bias in precision-weighted meta-analysis, requiring correction [43]. To assess the potential for scale-dependence, it is recommended that analysts test for possible covariation among plot size, replication, variances, and efect sizes [104]. If detected, analysts should use an efect size measure that is less sensitive to scale dependence (lnRR), and could use the size of a plot as a moderator in meta-regression, or alternatively, they consider running an unweighted model ([7]; note that only $1 2 \%$ , 9 out of 73 studies, accounted for sampling area in some way; Additional fle 1).

# Missing data

In many felds, meta-analytic data almost always encompass missing values see [106–108]. Broadly, we have two types of missing data in meta-analyses [109, 110]: (1) missing data in standard deviations or sample sizes, associated with means, preventing efect size calculations (Table  2), and (2) missing data in moderators. Tere are several solutions for both types. Te best, and frst to try, should be contacting the authors. If this fails, we can potentially ‘impute’ missing data. Single imputation methods using the strong correlation between standard deviation and mean values (known as mean– variance relationship) are available, although single imputation can lead to Type I error [106, 107] (see also [43]) because we do not model the uncertainty of imputation itself. Contrastingly, multiple imputation, which creates multiple versions of imputed datasets, incorporates such uncertainty. Indeed, multiple imputation is a preferred and proven solution for missing data in efect sizes and moderators [109, 110]. Yet, correct implementation can be challenging (see [110]). What we require now is an automated pipeline of merging meta-analysis and multiple imputation, which accounts for imputation uncertainty, although it may be challenging for complex meta-analytic models. Fortunately, however, for lnRR, there is a series of new methods that can perform better than the conventional method and which can deal with missing SDs [44]; note that these methods do not deal with missing moderators. Terefore, where applicable, we recommend these new methods, until an easy-toimplement multiple imputation workfow arrives.

# Complex non‑independence

Above, we have only dealt with the model that includes study identities as a clustering/grouping (random) factor. However, many datasets are more complex, with potentially more clustering variables in addition to the study identity. It is certainly possible that an environmental meta-analysis contains data from multiple species. Such a situation creates an interesting dependence among efect sizes from diferent species, known as phylogenetic relatedness, where closely related species are more likely to be similar in efect sizes compared to distantly related ones (e.g., mice vs. rats and mice vs. sparrows). Our multilevel model framework is fexible and can accommodate phylogenetic relatedness. A phylogenetic multilevel metaanalytic model can be written as [40, 111, 112]:

$$
z _ { i } = \beta _ { 0 } + a _ { k [ i ] } + s _ { k [ i ] } + u _ { j [ i ] } + e _ { i } + m _ { i } ,
$$

$$
\begin{array} { r l } & { a _ { k } \sim \mathrm { N } \Big ( 0 , \omega ^ { 2 } \mathrm { A } \Big ) , s _ { k } \sim \mathrm { N } \Big ( 0 , \gamma ^ { 2 } \Big ) , u _ { j } \sim \mathrm { N } \Big ( 0 , \tau ^ { 2 } \Big ) , } \\ & { e _ { i } \sim \mathrm { N } \Big ( 0 , \sigma ^ { 2 } \Big ) , \ : \& m _ { i } \sim \mathrm { N } ( 0 , \nu _ { i } ) , } \end{array}
$$

where $a _ { k [ i ] }$ is the phylogenetic (species) efect for the kth species (efect size i; $N _ { e f f e c t }$ $( i { = } 1 , 2 { , } . . . , N _ { e f f e c t } ) { > } N _ { s t u d y }$ $( j = 1 , \ 2 , . . . , N _ { s t u d y } ) > N _ { s p e c i e s } \ ( \tilde { k } = 1 , \ 2 , . . . , N _ { s p e c i e s } ) \tilde { ) }$ ), normally distributed with $\omega ^ { 2 } \mathrm { A }$ where is the phylogenetic variance and A is a correlation matrix coding how close each species are to each other and $\omega ^ { 2 }$ is the phylogenetic variance, $s _ { k [ i ] }$ is the non-phylogenetic (species) efect for the kth species (efect size $i$ ), normally distributed with the variance of $\gamma ^ { 2 }$ (the non-phylogenetic variance), and other notations are as above. It is important to realize that A explicitly models relatedness among species, and we do need to provide this correlation matrix, using a distance relationship usually derived from a molecular-based phylogenetic tree (for more details, see [40, 111, 112]). Some may think that the non-phylogenetic term $( s _ { k [ i ] } )$ is unnecessary or redundant because $s _ { k [ i ] }$ and the phylogenetic term $( a _ { k [ i ] } )$ are both modelling variance at the species level. However, a simulation recently demonstrated that failing to have the non-phylogenetic term $( s _ { k [ i ] } )$ will often infate the phylogenetic variance $\omega ^ { 2 }$ , leading to an incorrect conclusion that there is a strong phylogenetic signal (as shown in [112]). Te non-phylogenetic variance $( \gamma ^ { 2 } )$ arises from, for example, ecological similarities among species (herbivores vs. carnivores or arboreal vs. groundliving) not phylogeny [40].

Like phylogenetic relatedness, efect sizes arising from closer geographical locations are likely to be more correlated [113]. Statistically, spatial correlation can be also modelled in a manner analogous to phylogenetic relatedness (i.e., rather than a phylogenetic correlation matrix, A, we ft a spatial correlation matrix). For example, Maire and colleagues [114] used a meta-analytic model with spatial autocorrelation to investigate the temporal trends of fsh communities in the network of rivers in France. We note that a similar argument can be made for temporal correlation, but in many cases, temporal correlations could be dealt with, albeit less accurately, as a special case of ‘shared measurements’, as in Fig. 2. An important idea to take away is that one can model diferent, if not all, types of non-independence as the random factor(s) in a multilevel model.

# Advanced techniques

Here we touch upon fve advanced meta-analytic techniques with potential utility for environmental sciences, providing relevant references so that interested readers can obtain more information on these advanced topics. Te frst one is the meta-analysis of magnitudes, or absolute values (efect sizes), where researchers may be interested in deviations from 0, rather than the directionality of the efect [115]. For example, Cohen and colleagues [116] investigated absolute values of phenological responses, as they were concerned with the magnitudes of changes in phenology rather than directionality.

Te second method is the meta-analysis of interaction where our focus is on synthesizing the interaction efect of, usually, $2 \times 2$ factorial design (e.g., the efect of two simultaneous environmental stressors [54, 117, 118]; see also [119]). Recently, Siviter and colleagues [120] showed that agrochemicals interact synergistically (i.e., non-additively) to increase the mortality of bees; that is, two agrochemicals together caused more mortality than the sum of mortalities of each chemical.

Tird, network meta-analysis has been heavily used in medical sciences; network meta-analysis usually compares diferent treatments in relation to placebo and ranks these treatments in terms of efectiveness [121]. Te very frst ‘environmental’ network meta-analysis, as far as we know, investigated the efectives of ecosystem services among diferent land types [122].

Fourth, a multivariate meta-analysis is where one can model two or more diferent types of efect sizes with the estimation of pair-wise correlations between diferent efect sizes. Te beneft of such an approach is known as the ‘borrowing of strength’, where the error of fxed efects (moderators; e.g., $b _ { 0 }$ and $b _ { 1 }$ ) can be reduced when diferent types of efect sizes are correlated (i.e., $s e ( b _ { 0 } )$ and $s e ( b _ { 1 } )$ can be smaller [123]) For example, it is possible for lnRR (diferences in mean) and lnVR (diferences in SDs) to be modelled together (cf. [124]).

Fifth, as with network meta-analysis, there has been a surge in the use of ‘individual participants data’, called ‘IPD meta-analysis’, in medical sciences [125, 126]. Te idea of IPD meta-analysis is simple—rather than using summary statistics reported in papers (sample means and variances), we directly use raw data from all studies. We can either model raw data using one complex multilevel (hierarchical) model (one-step method) or calculate statistics for each study and use a meta-analysis (two-step method; note that both methods will usually give the same results). Study-level random efects can be incorporated to allow the response variable of interest to vary among studies, and overall efects correspond to fxed, population-level estimates. Te use of IPD or ‘full-data analyses’ has also surged in ecology, aided by open-science policies that encourage the archival of raw data alongside articles, and initiatives that synthesise raw data (e.g., PREDICTS [127], BioTime [128]). In health disciplines, such meta-analyses are considered the ‘gold standard’ [129], owing to their potential for resolving issues regarding study-specifc designs and confounding variation, and it is unclear whether and how they might resolve issues such as scale dependence in environmental meta-analyses [104, 130].

# Conclusions

In this article, we have attempted to describe the most practical ways to conduct quantitative synthesis, including meta-analysis, meta-regression, and publication bias tests. In addition, we have shown that there is much to be improved in terms of meta-analytic practice and reporting via a survey of 73 recent environmental meta-analyses. Such improvements are urgently required, especially given the potential infuence that environmental meta-analyses can have on policies and decision-making [8]. So often, meta-analysts have called for better reporting of primary research (e.g. [131, 132]), and now this is the time to raise the standards of reporting in meta-analyses. We hope our contribution will help to catalyse a turning point for better practice in quantitative synthesis in environmental sciences. We remind the reader most of what is described is implemented in the $R$ environment on our tutorial webpage and researchers can readily use the proposed models and techniques (https://itchyshin.github.io/ Meta-analysis_tutorial/). Finally, meta-analytic techniques are always developing and improving. It is certainly possible that in the future, our proposed models and related methods will become dated, just as the traditional fxed-efect and random-efects models already are. Terefore, we must endeavour to be open-minded to new ways of doing quantitative research synthesis in environmental sciences.

# Supplementary Information

The online version contains supplementary material available at https://doi.   
org/10.1186/s13750-023-00301-6.

Additional fle 1: The survey of meta-analyses in environmnetal sciences.

Additional fle 2: The hands-on R tutorial.

# Acknowledgements

SN, ELM, and ML were supported by the ARC (Australian Research Council) Discovery grant (DP200100367), and SN, YY, and ML by the ARC Discovery grant (DP210100812). YY was also supported by the National Natural Science Foundation of China (32102597). A part of this research was conducted while visiting the Okinawa Institute of Science and Technology (OIST) through the Theoretical Sciences Visiting Program (TSVP) to SN.

# Author contributions

SN was commissioned to write this article so he assembled a team of co-authors. SN discussed the idea with YY, ELM, RS and ML, and all of them contributed to the design of this review. ML led the survey working with YY and ELM, while YY led the creation of the accompanying webpage working with RS. SN supervised all aspects of this work and wrote the frst draft, which was commented on, edited, and therefore, signifcantly improved by the other co-authors. All authors read and approved the fnal manuscript.

# Funding

Australian Research Council Discovery grant (DP200100367); Australian Research Council Discovery grant (DP210100812); The National Natural Science Foundation of China (32102597).

# Availability of data and materials

All data and material are provided as additional fles.

# Declarations

Ethics approval and consent to participate Not applicable.

# Contest for publication

The authors provide consent for publication.

# Competing interests

The authors report no competing interests.

# Author details

1 Evolution & Ecology Research Centre and School of Biological, Earth and Environmental Sciences, University of New South Wales, Sydney, NSW 2052, Australia. 2 Theoretical Sciences Visiting Program, Okinawa Institute of Science and Technology Graduate University, Onna 904-0495, Japan. 3 School of Biological Sciences, Whiteknights Campus, University of Reading, Reading RG6 6AS, UK.

Received: 13 January 2023 Accepted: 23 March 2023   
Published online: 24 April 2023

# References

1. Higgins JP, Thomas JE, Chandler JE, Cumpston ME, Li TE, Page MJ, Welch VA. Cochrane handbook for systematic reviews of interventions. 2nd ed Chichester: Wikey; 2019.   
2. Cooper HM, Hedges LV, Valentine JC. The handbook of research syn‑ thesis and meta-analysis. 3rd ed. New York: Russell Sage Foundation; 2019.   
3. Schmid CH, Stijnen TE, White IE. Handbook of meta-analysis. 1st ed. Boca Ranton: CRC; 2021.   
4. Vetter D, Rucker G, Storch I. Meta-analysis: a need for well-defned usage in ecology and conservation biology. Ecosphere. 2013;4(6):1.   
5. Koricheva J, Gurevitch J, Mengersen K, editors. Handbook of metaanalysis in ecology and evolution. Princeton: Princeton Univesity Press; 2017.   
6. Gurevitch J, Koricheva J, Nakagawa S, Stewart G. Meta-analysis and the science of research synthesis. Nature. 2018;555(7695):175–82.   
7. Spake R, Doncaster CP. Use of meta-analysis in forest biodiversity research: key challenges and considerations. Forest Ecol Manag. 2017;400:429–37.   
8. Bilotta GS, Milner AM, Boyd I. On the use of systematic reviews to inform environmental policies. Environ Sci Policy. 2014;42:67–77.   
9. Hedges LV, Vevea JL. Fixed- and random-efects models in meta-analysis. Psychol Methods. 1998;3(4):486–504.   
10. Borenstein M, Hedges LV, Higgins JPT, Rothstein H. Introduction to meta-analysis. 2nd ed. Chichester: Wiley; 2021.   
11. Noble DWA, Lagisz M, Odea RE, Nakagawa S. Nonindependence and sensitivity analyses in ecological and evolutionary meta-analyses. Mol Ecol. 2017;26(9):2410–25.   
12. Nakagawa S, Noble DWA, Senior AM, Lagisz M. Meta-evaluation of meta-analysis: ten appraisal questions for biologists. Bmc Biol. 2017;15:1.   
13. Nakagawa S, Senior AM, Viechtbauer W, Noble DWA. An assessment of statistical methods for nonindependent data in ecological meta-analyses: comment. Ecology. 2022;103(1): e03490.   
14. Romanelli JP, Meli P, Naves RP, Alves MC, Rodrigues RR. Reliability of evidence-review methods in restoration ecology. Conserv Biol. 2021;35(1):142–54.   
15. Koricheva J, Gurevitch J. Uses and misuses of meta-analysis in plant ecology. J Ecol. 2014;102(4):828–44.   
16. O’Leary BC, Kvist K, Bayliss HR, Derroire G, Healey JR, Hughes K, Kleinschroth F, Sciberras M, Woodcock P, Pullin AS. The reliability of evidence review methodology in environmental science and conservation. Environ Sci Policy. 2016;64:75–82.   
17. Rosenthal R. The “fle drawer problem” and tolerance for null results. Psychol Bull. 1979;86(3):638–41.   
18. Nakagawa S, Lagisz M, Jennions MD, Koricheva J, Noble DWA, Parker TH, Sánchez-Tójar A, Yang Y, O’Dea RE. Methods for testing publication bias in ecological and evolutionary meta-analyses. Methods Ecol Evol. 2022;13(1):4–21.   
19. Cheung MWL. A guide to conducting a meta-analysis with non-independent efect sizes. Neuropsychol Rev. 2019;29(4):387–96.   
20. Viechtbauer W. Conducting meta-analyses in R with the metafor package. J Stat Softw. 2010;36(3):1–48.   
21. Yang Y, Macleod M, Pan J, Lagisz M, Nakagawa S. Advanced methods and implementations for the meta-analyses of animal models: current practices and future recommendations. Neurosci Biobehav Rev. 2022. https://doi.org/10.1016/j.neubiorev.2022.105016:105016.   
22. Nakagawa S, Cuthill IC. Efect size, confdence interval and statistical signifcance: a practical guide for biologists. Biol Rev. 2007;82(4):591–605.   
23. Hedges LV, Gurevitch J, Curtis PS. The meta-analysis of response ratios in experimental ecology. Ecology. 1999;80(4):1150–6.   
24. Friedrich JO, Adhikari NKJ, Beyene J. The ratio of means method as an alternative to mean diferences for analyzing continuous outcome variables in meta-analysis: A simulation study. BMC Med Res Methodol. 2008;8:5.   
25. Hedges L, Olkin I. Statistical methods for meta-analysis. New York: Academic Press; 1985.   
26. Cohen J. Statistical power analysis for the beahvioral sciences. 2nd ed. Hillsdale: Lawrence Erlbaum; 1988.   
27. Senior AM, Viechtbauer W, Nakagawa S. Revisiting and expanding the meta-analysis of variation: the log coefcient of variation ratio. Res Synth Methods. 2020;11(4):553–67.   
28. Nakagawa S, Poulin R, Mengersen K, Reinhold K, Engqvist L, Lagisz M, Senior AM. Meta-analysis of variation: ecological and evolutionary applications and beyond. Methods Ecol Evol. 2015;6(2):143–52.   
29. Knapp S, van der Heijden MGA. A global meta-analysis of yield stability in organic and conservation agriculture. Nat Commun. 2018;9:3632.   
30. Porturas LD, Anneberg TJ, Cure AE, Wang SP, Althof DM, Segraves KA. A meta-analysis of whole genome duplication and theefects on fowering traits in plants. Am J Bot. 2019;106(3):469–76.   
31. Janicke T, Morrow EH. Operational sex ratio predicts the opportunity and direction of sexual selection across animals. Ecol Lett. 2018;21(3):384–91.   
32. Chamberlain R, Brunswick N, Siev J, McManus IC. Meta-analytic fndings reveal lower means but higher variances in visuospatial ability in dyslexia. Brit J Psychol. 2018;109(4):897–916.   
33. O’Dea RE, Lagisz M, Jennions MD, Nakagawa S. Gender diferences in individual variation in academic grades fail to ft expected patterns for STEM. Nat Commun. 2018;9:3777.   
34. Brugger SP, Angelescu I, Abi-Dargham A, Mizrahi R, Shahrezaei V, Howes OD. Heterogeneity of striatal dopamine function in schizophrenia: meta-analysis of variance. Biol Psychiat. 2020;87(3):215–24.   
35. Usui T, Macleod MR, McCann SK, Senior AM, Nakagawa S. Meta-analysis of variation suggests that embracing variability improves both replicability and generalizability in preclinical research. Plos Biol. 2021;19(5): e3001009.   
36. Hofmann AA, Merila J. Heritable variation and evolution under favourable and unfavourable conditions. Trends Ecol Evol. 1999;14(3):96–101.   
37. Wood CW, Brodie ED 3rd. Environmental efects on the structure of the G-matrix. Evolution. 2015;69(11):2927–40.   
38. Hillebrand H, Donohue I, Harpole WS, Hodapp D, Kucera M, Lewandowska AM, Merder J, Montoya JM, Freund JA. Thresholds for ecological responses to global change do not emerge from empirical data. Nat Ecol Evol. 2020;4(11):1502.   
39. Yang YF, Hillebrand H, Lagisz M, Cleasby I, Nakagawa S. Low statistical power and overestimated anthropogenic impacts, exacerbated by publication bias, dominate feld studies in global change biology. Global Change Biol. 2022;28(3):969–89.   
40. Nakagawa S, Santos ESA. Methodological issues and advances in biological meta-analysis. Evol Ecol. 2012;26(5):1253–74.   
41. Bakbergenuly I, Hoaglin DC, Kulinskaya E. Estimation in meta-analyses of response ratios. BMC Med Res Methodol. 2020;20(1):1.   
42. Bakbergenuly I, Hoaglin DC, Kulinskaya E. Estimation in meta-analyses of mean diference and standardized mean diference. Stat Med. 2020;39(2):171–91.   
43. Doncaster CP, Spake R. Correction for bias in meta-analysis of littlereplicated studies. Methods Ecol Evol. 2018;9(3):634–44.   
44. Nakagawa S, Noble DW, Lagisz M, Spake R, Viechtbauer W, Senior AM. A robust and readily implementable method for the meta-analysis of response ratios with and without missing standard deviations. Ecol Lett. 2023;26(2):232–44   
45. Hamman EA, Pappalardo P, Bence JR, Peacor SD, Osenberg CW. Bias in meta-analyses using Hedges’ d. Ecosphere. 2018;9(9): e02419.   
46. Bakbergenuly I, Hoaglin DC, Kulinskaya E. On the Q statistic with constant weights for standardized mean diference. Brit J Math Stat Psy. 2022;75(3):444–65.   
47. DerSimonian R, Kacker R. Random-efects model for meta-analysis of clinical trials: an update. Contemp Clin Trials. 2007;28(2):105–14.   
48. Veroniki AA, Jackson D, Viechtbauer W, Bender R, Bowden J, Knapp G, Kuss O, Higgins JPT, Langan D, Salanti G. Methods to estimate the between-study variance and its uncertainty in meta-analysis. Res Synth Methods. 2016;7(1):55–79.   
49. Langan D, Higgins JPT, Simmonds M. Comparative performance of heterogeneity variance estimators in meta-analysis: a review of simulation studies. Res Synth Methods. 2017;8(2):181–98.   
50. Panityakul T, Bumrungsup C, Knapp G. On estimating residual heterogeneity in random-efects meta-regression: a comparative study. J Stat Theory Appl. 2013;12(3):253–65.   
51. Bishop J, Nakagawa S. Quantifying crop pollinator dependence and its heterogeneity using multi-level meta-analysis. J Appl Ecol. 2021;58(5):1030–42.   
52. Cheung MWL. Modeling dependent efect sizes with three-level metaanalyses: a structural equation modeling approach. Psychol Methods. 2014;19(2):211–29.   
53. Bolker BM, Brooks ME, Clark CJ, Geange SW, Poulsen JR, Stevens MHH, White JSS. Generalized linear mixed models: a practical guide for ecology and evolution. Trends Ecol Evol. 2009;24(3):127–35.   
54. Lajeunesse MJ. On the meta-analysis of response ratios for studies with correlated and multi-group designs. Ecology. 2011;92(11):2049–55.   
55. Gleser LJ, Olkin I. Stochastically dependent efect sizes. In: Cooper H, Hedges LV, Valentine JC, editors. The handbook of research synthesis and meta-analysis. New York: Russell Sage Foundation; 2009.   
56. Tipton E, Pustejovsky JE. Small-sample adjustments for tests of moderators and model ft using robust variance estimation in meta-regression. J Educ Behav Stat. 2015;40(6):604–34.   
57. Hedges LV, Tipton E, Johnson MC. Robust variance estimation in metaregression with dependent efect size estimates (vol 1, pg 39, 2010). Res Synth Methods. 2010;1(2):164–5.   
58. Pustejovsky JE, Tipton E. Meta-analysis with robust variance estimation: expanding the range of working models. Prev Sci. 2021. https://doi.org/ 10.1007/s11121-021-01246-3.   
59. Cairns M, Prendergast LA. On ratio measures of heterogeneity for metaanalyses. Res Synth Methods. 2022;13(1):28–47.   
60. Borenstein M, Higgins JPT, Hedges LV, Rothstein HR. Basics of metaanalysis: I2 is not an absolute measure of heterogeneity. Res Synth Methods. 2017;8(1):5–18.   
61. Hoaglin DC. Practical challenges of I-2 as a measure of heterogeneity. Res Synth Methods. 2017;8(3):254–254.   
62. Higgins JPT, Thompson SG. Quantifying heterogeneity in a meta-analysis. Stat Med. 2002;21(11):1539–58.   
63. Higgins JPT, Thompson SG, Deeks JJ, Altman DG. Measuring inconsistency in meta-analyses. Brit Med J. 2003;327(7414):557–60.   
64. Xiong CJ, Miller JP, Morris JC. Measuring study-specifc heterogeneity in meta-analysis: application to an antecedent biomarker study of   
65. Nakagawa S, Schielzeth H. Repeatability for Gaussian and non-Gaussian data: a practical guide for biologists. Biol Rev. 2010;85(4):935–56.   
66. Senior AM, Grueber CE, Kamiya T, Lagisz M, O’Dwyer K, Santos ESA, Nakagawa S. Heterogeneity in ecological and evolutionary meta-analyses: its magnitude and implications. Ecology. 2016;97(12):3293–9.   
67. Gelman A, Hill J. Data analysis using regression and multilevel/hierarchical models. Cambridge: Cambridge University Press; 2007.   
68. Schielzeth H. Simple means to improve the interpretability of regression coefcients. Methods Ecol Evol. 2010;1(2):103–13.   
69. Nakagawa S, Schielzeth H. A general and simple method for obtaining R2 from generalized linear mixed-efects models. Methods Ecol Evol.   
2013;4(2):133–42.   
70. Nakagawa S, Johnson PCD, Schielzeth H. The coefcient of determination R-2 and intra-class correlation coefcient from generalized linear mixed-efects models revisited and expanded. J R Soc Interface.   
2017;14(134):20170213.   
71. Aloe AM, Becker BJ, Pigott TD. An alternative to R-2 for assessing linear models of efect size. Res Synth Methods. 2010;1(3–4):272–83.   
72. Cinar O, Umbanhowar J, Hoeksema JD, Viechtbauer W. Using information-theoretic approaches for model selection in meta-analysis. Res Synth Methods. 2021. https://doi.org/10.1002/jrsm.1489.   
73. Viechtbauer W. Model checking in meta-analysis. In: Schmid CH, Stijnen T, White IR, editors. Handbook of meta-analysis. Boca Raton: CRC; 2021.   
74. Anzures-Cabrera J, Higgins JPT. Graphical displays for meta-analysis: An overview with suggestions for practice. Res Synth Methods.   
2010;1(1):66–80.   
75. Kossmeier M, Tran US, Voracek M. Charting the landscape of graphical displays for meta-analysis and systematic reviews: a comprehensive review, taxonomy, and feature analysis. Bmc Med Res Methodol.   
2020;20(1):1.   
76. Intout J, Ioannidis JPA, Rovers MM, Goeman JJ. Plea for routinely presenting prediction intervals in meta-analysis. BMJ Open. 2016;6(7): e010247.   
77. Moeyaert M, Ugille M, Beretvas SN, Ferron J, Bunuan R, Van den Noortgate W. Methods for dealing with multiple outcomes in meta-analysis a comparison between averaging efect sizes, robust variance estimation and multilevel meta-analysis. Int J Soc Res Methodol. 2017;20:559.   
78. Nakagawa S, Lagisz M, O’Dea RE, Rutkowska J, Yang YF, Noble DWA, Senior AM. The orchard plot: cultivating a forest plot for use in ecology, evolution, and beyond. Res Synth Methods. 2021;12(1):4–12.   
79. Rothstein H, Sutton AJ, Borenstein M. Publication bias in meta-analysis : prevention, assessment and adjustments. Hoboken: Wiley; 2005.   
80. Nakagawa S, Lagisz M, Jennions MD, Koricheva J, Noble DWA, Parker TH, Sanchez-Tojar A, Yang YF, O’Dea RE. Methods for testing publication bias in ecological and evolutionary meta-analyses. Methods Ecol Evol.   
2022;13(1):4–21.   
81. Stanley TD, Doucouliagos H. Meta-regression analysis in economics and business. New York: Routledge; 2012.   
82. Stanley TD, Doucouliagos H. Meta-regression approximations to reduce publication selection bias. Res Synth Methods. 2014;5(1):60–78.   
83. Sterne JAC, Becker BJ, Egger M. The funnel plot. In: Rothstein H, Sutton AJ, Borenstein M, editors. Publication bias in meta-analysis: prevention, assessment and adjustments. Chichester: Wiley; 2005. p. 75–98.   
84. Sterne JAC, Sutton AJ, Ioannidis JPA, Terrin N, Jones DR, Lau J, Carpenter J, Rucker G, Harbord RM, Schmid CH, et al. Recommendations for examining and interpreting funnel plot asymmetry in meta-analyses of randomised controlled trials. Br Med J. 2011;343:4002.   
85. Egger M, Smith GD, Schneider M, Minder C. Bias in meta-analysis detected by a simple, graphical test. Brit Med J. 1997;315(7109):629–34.   
86. Jennions MD, Moller AP. Relationships fade with time: a meta-analysis of temporal trends in publication in ecology and evolution. P Roy Soc B-Biol Sci. 2002;269(1486):43–8.   
87. Koricheva J, Kulinskaya E. Temporal instability of evidence base: a threat to policy making? Trends Ecol Evol. 2019;34(10):895–902.   
88. Raue A, Kreutz C, Maiwald T, Bachmann J, Schilling M, Klingmuller U, Timmer J. Structural and practical identifability analysis of partially observed dynamical models by exploiting the profle likelihood. Bioinformatics. 2009;25(15):1923–9.   
89. Matsushima Y, Noma H, Yamada T, Furukawa TA. Infuence diagnostics and outlier detection for meta-analysis of diagnostic test accuracy. Res Synth Methods. 2020;11(2):237–47.   
90. Viechtbauer W, Cheung MWL. Outlier and infuence diagnostics for meta-analysis. Res Synth Methods. 2010;1(2):112–25.   
91. Haddaway NR, Macura B. The role of reporting standards in producing robust literature reviews comment. Nat Clim Change. 2018;8(6):444–7.   
92. Frampton G, Whaley P, Bennett M, Bilotta G, Dorne JLCM, Eales J, James K, Kohl C, Land M, Livoreil B, et al. Principles and framework for assessing the risk of bias for studies included in comparative quantitative environmental systematic reviews. Environ Evid. 2022;11(1):12.   
93. Stanhope J, Weinstein P. Critical appraisal in ecology: what tools are available, and what is being used in systematic reviews? Res Synth Methods. 2022. https://doi.org/10.1002/jrsm.1609.   
94. Haddaway NR, Macura B, Whaley P, Pullin AS. ROSES RepOrting standards for systematic evidence syntheses: pro forma, fow-diagram and descriptive summary of the plan and conduct of environmental systematic reviews and systematic maps. Environ Evid. 2018;7(1):1.   
95. Woodcock P, Pullin AS, Kaiser MJ. Evaluating and improving the reliability of evidence syntheses in conservation and environmental science: a methodology. Biol Conserv. 2014;176:54–62.   
96. O’Dea RE, Lagisz M, Jennions MD, Koricheva J, Noble DWA, Parker TH, Gurevitch J, Page MJ, Stewart G, Moher D, et al. Preferred reporting items for systematic reviews and meta-analyses in ecology and evolutionary biology: a PRISMA extension. Biol Rev. 2021;96(5):1695–722.   
97. Moher D, Liberati A, Tetzlaf J, Altman DG. Preferred reporting items for systematic reviews and meta-analyses: the PRISMA statement. Plos Med. 2009;6(7):e1000097.   
98. Page MJ, McKenzie JE, Bossuyt PM, Boutron I, Hofmann TC, Mulrow CD, Shamseer L, Tetzlaf JM, Akl EA, Brennan SE, et al. The PRISMA 2020 statement: an updated guideline for reporting systematic reviews. Plos Med. 2021;18(3): e1003583.   
99. Wilkinson MD, Dumontier M, Aalbersberg IJ, Appleton G, Axton M, Baak A, Blomberg N, Boiten JW, Santos LBD, Bourne PE, et al. Comment: the FAIR guiding principles for scientifc data management and stewardship. Sci Data. 2016;3: 160018.   
100. Culina A, Baglioni M, Crowther TW, Visser ME, Woutersen-Windhouwer S, Manghi P. Navigating the unfolding open data landscape in ecology and evolution. Nat Ecol Evol. 2018;2(3):420–6.   
101. Roche DG, Lanfear R, Binning SA, Haf TM, Schwanz LE, Cain KE, Kokko H, Jennions MD, Kruuk LE. Troubleshooting public data archiving: suggestions to increase participation. Plos Biol. 2014;12(1): e1001779.   
102. Roche DG, Kruuk LEB, Lanfear R, Binning SA. Public data archiving in ecology and evolution: how well are we doing? Plos Biol. 2015;13(11): e1002295.   
103. Culina A, van den Berg I, Evans S, Sanchez-Tojar A. Low availability of code in ecology: a call for urgent action. Plos Biol. 2020;18(7): e3000763.   
104. Spake R, Mori AS, Beckmann M, Martin PA, Christie AP, Duguid MC, Doncaster CP. Implications of scale dependence for cross-study syntheses of biodiversity diferences. Ecol Lett. 2021;24(2):374–90.   
105. Osenberg CW, Sarnelle O, Cooper SD. Efect size in ecological experiments: the application of biological models in meta-analysis. Am Nat. 1997;150(6):798–812.   
106. Noble DWA, Nakagawa S. Planned missing data designs and methods: options for strengthening inference, increasing research efciency and improving animal welfare in ecological and evolutionary research. Evol Appl. 2021;14(8):1958–68.   
107. Nakagawa S, Freckleton RP. Missing inaction: the dangers of ignoring missing data. Trends Ecol Evol. 2008;23(11):592–6.   
108. Mavridis D, Chaimani A, Efthimiou O, Leucht S, Salanti G. Addressing missing outcome data in meta-analysis. Evid-Based Ment Health. 2014;17(3):85.   
109. Ellington EH, Bastille-Rousseau G, Austin C, Landolt KN, Pond BA, Rees EE, Robar N, Murray DL. Using multiple imputation to estimate missing data in meta-regression. Methods Ecol Evol. 2015;6(2):153–63.   
110. Kambach S, Bruelheide H, Gerstner K, Gurevitch J, Beckmann M, Seppelt R. Consequences of multiple imputation of missing standard deviations and sample sizes in meta-analysis. Ecol Evol. 2020;10(20):11699–712.   
111. Hadfeld JD, Nakagawa S. General quantitative genetic methods for comparative biology: phylogenies, taxonomies and multi-trait models for continuous and categorical characters. J Evol Biol. 2010;23(3):494–508.   
112. Cinar O, Nakagawa S, Viechtbauer W. Phylogenetic multilevel metaanalysis: a simulation study on the importance of modelling the phylogeny. Methods Ecol Evol. 2021. https://doi.org/10.1111/2041- 210X.13760.   
113. Ives AR, Zhu J. Statistics for correlated data: phylogenies, space, and time. Ecol Appl. 2006;16(1):20–32.   
114. Maire A, Thierry E, Viechtbauer W, Daufresne M. Poleward shift in largeriver fsh communities detected with a novel meta-analysis framework. Freshwater Biol. 2019;64(6):1143–56.   
115. Morrissey MB. Meta-analysis of magnitudes, diferences and variation in evolutionary parameters. J Evol Biol. 2016;29(10):1882–904.   
116. Cohen JM, Lajeunesse MJ, Rohr JR. A global synthesis of animal phenological responses to climate change. Nat Clim Change. 2018;8(3):224.   
117. Gurevitch J, Morrison JA, Hedges LV. The interaction between competition and predation: a meta-analysis of feld experiments. Am Nat. 2000;155(4):435–53.   
118. Macartney EL, Lagisz M, Nakagawa S. The relative benefts of environmental enrichment on learning and memory aregreater when stressed: a meta-analysis of interactions in rodents. Neurosci Biobehav R. 2022. https://doi.org/10.1016/j.neubiorev.2022.104554.   
119. Spake R, Bowler DE, Callaghan CT, Blowes SA, Doncaster CP, Antão LH, Nakagawa S, McElreath R, Chase JM. Understanding ‘it depends’ in ecology: a guide to hypothesising, visualising and interpreting statistical interactions. Biol Rev. 2023. https://doi.org/10.1111/brv.12939.   
120. Siviter H, Bailes EJ, Martin CD, Oliver TR, Koricheva J, Leadbeater E, Brown MJF. Agrochemicals interact synergistically to increase bee mortality. Nature. 2021;596(7872):389.   
121. Salanti G, Schmid CH. Research synthesis methods special issue on network meta-analysis: introduction from the editors. Res Synth Methods. 2012;3(2):69–70.   
122. Gomez-Creutzberg C, Lagisz M, Nakagawa S, Brockerhof EG, Tylianakis JM. Consistent trade-ofs in ecosystem services between land covers with diferent production intensities. Biol Rev. 2021;96(5):1989–2008.   
123. Jackson D, White IR, Price M, Copas J, Riley RD. Borrowing of strength and study weights in multivariate and network meta-analysis. Stat Methods Med Res. 2017;26(6):2853–68.   
124. Sanchez-Tojar A, Moran NP, O’Dea RE, Reinhold K, Nakagawa S. Illustrating the importance of meta-analysing variances alongside means in ecology and evolution. J Evol Biol. 2020;33(9):1216–23.   
125. Riley RD, Lambert PC, Abo-Zaid G. Meta-analysis of individual participant data: rationale, conduct, and reporting. BMJ. 2010;340:c221.   
126. Riley RD, Tierney JF, Stewart LA. Individual participant data meta-analysis : a handbook for healthcare research. 1st ed. Hoboken: Wiley; 2021.   
127. Hudson LN, Newbold T, Contu S, Hill SLL, Lysenko I, De Palma A, Phillips HRP, Alhusseini TI, Bedford FE, Bennett DJ, et al. The database of the PREDICTS (projecting responses of ecological diversity in changing terrestrial systems) project. Ecol Evol. 2017;7(1):145–88.   
128. Dornelas M, Antao LH, Moyes F, Bates AE, Magurran AE, Adam D, Akhmetzhanova AA, Appeltans W, Arcos JM, Arnold H, et al. BioTIME: a database of biodiversity time series for the anthropocene. Glob Ecol Biogeogr. 2018;27(7):760–86.   
129. Mengersen K, Gurevitch J, Schmid CH. Meta-analysis of primary data. In: Koricheva J, Gurevitch J, Mengersen K, editors. Handbook of metaanalysis in ecology and evolution. Priceton: Princeton university; 2013. p. 300–12.   
130. Spake R, O’Dea RE, Nakagawa S, Doncaster CP, Ryo M, Callaghan CT, Bullock JM. Improving quantitative synthesis to achieve generality in ecology. Nat Ecol Evol. 2022;6(12):1818–28.   
131. Gerstner K, Moreno-Mateos D, Gurevitch J, Beckmann M, Kambach S, Jones HP, Seppelt R. Will your paper be used in a meta-analysis? Make the reach of your research broader and longer lasting. Methods Ecol Evol. 2017;8(6):777–84.   
132. Haddaway NR. A call for better reporting of conservation research data for use in meta-analyses. Conserv Biol. 2015;29(4):1242–5.   
133. Midolo G, De Frenne P, Holzel N, Wellstein C. Global patterns of intraspecifc leaf trait responses to elevation. Global Change Biol. 2019;25(7):2485–98.   
134. White IR, Schmid CH, Stijnen T. Choice of efect measure and issues in extracting outcome data. In: Schmid CH, Stijnen T, White IR, editors. Handbook of meta-analysis. Boca Raton: CRC; 2021.   
135. Lajeunesse MJ. Bias and correction for the log response ratio in ecological meta-analysis. Ecology. 2015;96(8):2056–63.

# Publisher’s Note

Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional afliations.

# Ready to submit your research? Choose BMC and benefit from:

• fast, convenient online submission   
• thorough peer review by experienced researchers in your field   
• rapid publication on acceptance   
• support for research data, including large and complex data types   
• gold Open Access which fosters wider collaboration and increased citations   
• maximum visibility for your research: over 100M website views per year

# At BMC, research is always in progress.

Learn more biomedcentral.com/submissions